﻿using System;

namespace ExtrudeModifier
{

	/// <summary>
	/// Defines the object channels that can be changed by a modifier.
	/// </summary>
	[Flags]
	enum ChannelMask : uint
	{

		/// <summary>
		/// The topology channel - the face or polygon structures. 
		/// </summary>
		TOPO_CHANNEL = (1 << 0),


		/// <summary>
		/// 
		/// </summary>
		GEOM_CHANNEL = (1 << 1),

		/// <summary>
		/// The texture vertices and procedural mappings. 
		/// </summary>
		TEXMAP_CHANNEL = (1 << 2),


		/// <summary>
		/// This is no longer used. 
		/// </summary>
		MTL_CHANNEL = (1 << 3),

		/// <summary>
		/// The sub-object selection channel. 
		/// </summary>
		SELECT_CHANNEL = (1 << 4),

		/// <summary>
		/// The current level of selection. 
		/// </summary>
		SUBSEL_TYPE_CHANNEL = (1 << 5),


		/// <summary>
		/// The miscellaneous bits controlling the item's display. 
		/// </summary>
		DISP_ATTRIB_CHANNEL = (1 << 6),

		/// <summary>
		/// The color per vertex channel. 
		/// </summary>
		VERTCOLOR_CHANNEL = (1 << 7),

		/// <summary>
		/// The used internally by 3ds Max for stripping. 
		/// </summary>
		GFX_DATA_CHANNEL = (1 << 8),

		/// <summary>
		/// Displacement approximation. 
		/// </summary>
		DISP_APPROX_CHANNEL = (1 << 9),

		/// <summary>
		/// The channel used by extension channel objects. 
		/// </summary>
		EXTENSION_CHANNEL = (1 << 13),


		/// <summary>
		/// The ObjectState TM that flows down the pipeline. 
		/// </summary>
		TM_CHANNEL = (1 << 10),

		/// <summary>
		/// For internal use.
		/// </summary>
		EDGEVISIBLITY_CHANNEL = (1 << 11),

		/// <summary>
		/// For internal use.
		/// </summary>
		DONT_RECREATE_TRISTRIP_CHANNEL = (1 << 12),

		/// <summary>
		/// This is no longer used.
		/// </summary> 
		GLOBMTL_CHANNEL = ((uint)1 << 31),


		OBJ_CHANNELS = (TOPO_CHANNEL | GEOM_CHANNEL | SELECT_CHANNEL | TEXMAP_CHANNEL | MTL_CHANNEL | SUBSEL_TYPE_CHANNEL | DISP_ATTRIB_CHANNEL | VERTCOLOR_CHANNEL | GFX_DATA_CHANNEL | DISP_APPROX_CHANNEL | EXTENSION_CHANNEL),
		ALL_CHANNELS = (OBJ_CHANNELS | TM_CHANNEL | GLOBMTL_CHANNEL)

	}

}
